/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.sourcemap;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.sourcemap.ISourceMap;
import com.aptana.core.sourcemap.ISourceMapRegistry;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class SourceMapRegistry
implements ISourceMapRegistry {
    private static final String EXTENSION_POINT_ID = "sourceMaps";
    private static final String ELEMENT_TYPE = "sourceMap";
    private static final String CLASS_ATTR = "class";
    private static final String NATURE_ID_ATTR = "projectNatureId";
    protected Map<String, IConfigurationElement> sourceMappers;

    public ISourceMap getSourceMap(IProject project, String platform) {
        if (project == null || !project.isAccessible()) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), "Could not get the sourcemap. The given project was null or not accessible");
            return null;
        }
        this.lazyLoad();
        Object[] natureIds = null;
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException ce) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), ce);
            return null;
        }
        if (ArrayUtil.isEmpty(natureIds)) {
            return null;
        }
        return this.getSourceMap(project, (String)natureIds[0], platform);
    }

    public ISourceMap getSourceMap(IProject project, String projectNatureId, String platform) {
        if (StringUtil.isEmpty(projectNatureId)) {
            return null;
        }
        this.lazyLoad();
        IConfigurationElement element = this.sourceMappers.get(projectNatureId);
        if (element == null) {
            return null;
        }
        try {
            ISourceMap sourceMap = (ISourceMap)element.createExecutableExtension(CLASS_ATTR);
            sourceMap.setInitializationData(element, platform, project);
            return sourceMap;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
            return null;
        }
    }

    protected synchronized void lazyLoad() {
        if (this.sourceMappers == null) {
            this.sourceMappers = new HashMap<String, IConfigurationElement>();
            EclipseUtil.processConfigurationElements("com.aptana.core", EXTENSION_POINT_ID, new IConfigurationElementProcessor(){

                @Override
                public void processElement(IConfigurationElement element) {
                    SourceMapRegistry.this.sourceMappers.put(element.getAttribute(SourceMapRegistry.NATURE_ID_ATTR), element);
                }

                @Override
                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet(SourceMapRegistry.ELEMENT_TYPE);
                }
            });
        }
    }
}

